/******************************************************************************
 * (C) Copyright 2000 by Agilent Technologies GmbH. All rights reserved.      *
 ******************************************************************************/


/* ---------------------------------------------------------------
 * File: xser16.h
 * -----------------------------------------------------------------*/


#ifndef XSER16_H_INCLUDED
#define XSER16_H_INCLUDED

#include <xpciapii.h>

#define BASE_COM1   0x3f8
#define BASE_COM2   0x2f8
#define BASE_COM3   0x3e8
#define BASE_COM4   0x2e8

#define BX_9600    12
#define BX_19200    6
#define BX_38400    3
#define BX_57600    2
#define BX_115200   1

/* register offsets */
#define COM_INTR_ACTIVE  0x01
#define COM_INTR_IDENT   0x02
#define COM_FIFO_CONTROL 0x02
#define COM_DATAFORMAT   0x03
#define COM_MODEMCONTROL 0x04
#define COM_SER_STATUS   0x05
#define COM_MODEM_STATUS 0x06

/* bits in serialising status register */
#define COM_RECEIVER_FULL_BIT  0x01
#define COM_OVERFLOW_BIT       0x02
#define COM_PAR_BIT            0x04
#define COM_FRAME_BIT          0x08
#define COM_BREAK_BIT          0x10
#define COM_SENDER_EMPTY_BIT   0x40

/* bits in modem status register */
#define COM_CTS_BIT            0x10
#define COM_DSR_BIT            0x20

/* bits in modem control register */
#define COM_SET_DTR_BIT        0x01
#define COM_SET_RTS_BIT        0x02


#endif

